/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1986,1987,1988,1989,1990 Texas Instruments Incorporated.*/
/*  All rights reserved.                                                 */
/*                                                                       */

#include <:bsd:netdb.h>
#include <:bsd:sys:socket.h>
#include <micronet-accessors.h>


/********************************************************/
/* GETHOSTBYNAME returns a ptr to an hostent structure  */
/* with athe following fields:                          */
/*   h_name     :  official name of host                */
/*   h_aliases  :  alias list                           */
/*   h_addrtype :  type of address being returned       */
/*   h_length   :  length of the address                */
/*   h_addr     :  a ptr to the network address for the */
/*                 host                                 */
/********************************************************/
static long host_nubus_addr = 0;
static long mx_nubus_addr = 0x0d;
static struct hostent  _hp ;

struct hostent *
gethostbyname(name)
char *name ;
{
	extern short mxslot;
	
	mx_nubus_addr = DriverData->mx_slot;
	_hp.h_name = name ;
	_hp.h_addrtype = AF_MAC ;
	_hp.h_length = 4 ;
	_hp.h_addr =  (char *) (strcmp(name, "mx") ? &host_nubus_addr : &mx_nubus_addr);   /* clm 9/27/89 - cast to (char *), see hostent definition.  */
	
	return(&_hp) ;
}
